<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Create permissions based on controllers
        $permissions = [
            // Dashboard
            'access dashboard',
            
            // User Management (UserController)
            'view users',
            'create users',
            'edit users',
            'delete users',
            
            // Role & Permission Management (RolePermissionController)
            'view roles',
            'create roles',
            'edit roles',
            'delete roles',
            'view permissions',
            'create permissions',
            'edit permissions',
            'delete permissions',
            
            // Configuration Management (ConfigurationController)
            'view configurations',
            'edit configurations',
            
            // Forum Management (ForumController)
            'view forum categories',
            'create forum categories',
            'edit forum categories',
            'delete forum categories',
            'view forum boards',
            'create forum boards',
            'edit forum boards',
            'delete forum boards',
            'moderate forums',
            'pin topics',
            'lock topics',
            
            // Package Management (PackageController)
            'view packages',
            'create packages',
            'edit packages',
            'delete packages',
            
            // Transaction Management (TransactionController)
            'view transactions',
            'create transactions',
            'edit transactions',
            'delete transactions',
            
            // Content management
            'create posts',
            'edit posts',
            'delete posts',
            'manage store',

            // News
            'create news',
            'delete news',
            'manage news',

            // Interactive Map
            'manage map',
            
            // Server management
            'manage server',
            'view logs',
            'manage bans',

            // Plugins
            'manage plugins',
        ];

        foreach ($permissions as $permission) {
            Permission::create(['name' => $permission]);
        }

        // Create roles and assign permissions
        
        // Member role (default for all users)
        $memberRole = Role::create(['name' => 'member']);
        
        // Moderator role
        $moderatorRole = Role::create(['name' => 'moderator']);
        $moderatorRole->givePermissionTo([
            'access dashboard',
            'view users',
            'view logs',
            'manage bans',
            'view forum categories',
            'view forum boards',
            'moderate forums',
            'pin topics',
            'lock topics',
            'view transactions',
            'view packages',
        ]);
        
        // Admin role
        $adminRole = Role::create(['name' => 'admin']);
        $adminRole->givePermissionTo([
            'access dashboard',
            
            // User management
            'view users',
            'create users',
            'edit users',
            'delete users',
            
            // Configuration
            'view configurations',
            'edit configurations',
            
            // Forum management
            'view forum categories',
            'create forum categories',
            'edit forum categories',
            'delete forum categories',
            'view forum boards',
            'create forum boards',
            'edit forum boards',
            'delete forum boards',
            'moderate forums',
            'pin topics',
            'lock topics',
            
            // Packages
            'view packages',
            'create packages',
            'edit packages',
            'delete packages',
            
            // Transactions
            'view transactions',
            'create transactions',
            'edit transactions',
            'delete transactions',
            
            // Content
            'create posts',
            'edit posts',
            'delete posts',
            'manage store',
            
            // Other
            'manage server',
            'view logs',
            'manage bans',
        ]);
        
        // Super Admin role - gets everything automatically
        $superAdminRole = Role::create(['name' => 'super-admin']);
        
        // Grant super-admin all other permissions
        $superAdminRole->givePermissionTo(Permission::all());
    }
}